/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.gui.wizard;

import com.quantumdata.sct.dao.vo.InputStepVO;
import com.quantumdata.sct.dao.vo.ParameterVO;
import com.quantumdata.sct.gui.common.SCTConstants;
import com.quantumdata.sct.gui.common.SCTLabel;
import com.quantumdata.sct.gui.common.SCTPanel;
import com.quantumdata.sct.gui.common.SCTTextArea;
import com.quantumdata.sct.gui.common.SCTTextField;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class InputSelectionPanel
extends JPanel
implements FocusListener {
    private SCTTextField inputSctTextField;
    private String labelName = "Label";
    private int size = 20;
    private InputStepVO stepVO;
    private boolean userFound = false;

    public InputSelectionPanel(String string, int n) {
        super(new BorderLayout());
        this.labelName = string;
        this.size = n;
        this.init();
    }

    public InputSelectionPanel(InputStepVO inputStepVO, int n, JCheckBox jCheckBox) {
        super(new BorderLayout());
        this.stepVO = inputStepVO;
        this.labelName = inputStepVO.getDescription();
        SCTPanel sCTPanel = new SCTPanel(new FlowLayout(1));
        this.inputSctTextField = new SCTTextField(15);
        this.inputSctTextField.addFocusListener(this);
        if (this.labelName == null || this.labelName.length() < 1) {
            SCTLabel sCTLabel = new SCTLabel("");
            sCTPanel.add(sCTLabel);
        } else {
            SCTTextArea sCTTextArea = new SCTTextArea(this.labelName, 2, 20);
            if (this.labelName.startsWith("USER")) {
                sCTTextArea.setBackground(SCTConstants.qdiColor);
                this.userFound = true;
            }
            sCTPanel.add(sCTTextArea);
        }
        if (jCheckBox != null) {
            sCTPanel.add(jCheckBox);
        }
        sCTPanel.add(this.inputSctTextField);
        this.add(sCTPanel);
    }

    public String getTextValue() {
        return this.inputSctTextField.getText();
    }

    public void setTextValue(String string) {
        this.inputSctTextField.setText(string);
    }

    private void init() {
        SCTPanel sCTPanel = new SCTPanel(new FlowLayout(1));
        SCTTextArea sCTTextArea = new SCTTextArea(this.labelName, 2, this.size);
        sCTPanel.add(sCTTextArea);
        this.inputSctTextField = new SCTTextField(20);
        sCTPanel.add(this.inputSctTextField);
        this.add(sCTPanel);
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        ParameterVO parameterVO;
        Collection collection;
        if (this.stepVO != null && !(collection = this.stepVO.getParameters()).isEmpty() && (ParameterVO.FLOAT.equals((parameterVO = (ParameterVO)collection.iterator().next()).getType()) || ParameterVO.INTEGER.equals(parameterVO.getType()))) {
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            try {
                String string = parameterVO.getLow();
                f = Float.parseFloat(string);
                String string2 = parameterVO.getHigh();
                f2 = Float.parseFloat(string2);
                f3 = Float.parseFloat(this.inputSctTextField.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (f3 < f || f3 > f2) {
                JOptionPane.showMessageDialog(this.getParent(), "Entered value out of range");
            }
        }
    }

    public boolean isUserStep() {
        return this.userFound;
    }
}

